######################################################
######## GROUP COMPOSITION AND EVALUATION ############
######################################################

setwd("C:/Data/Dropbox/Research/2014- Deliberative Polling/Analysis/")

data = read.csv("Composition.csv", header=TRUE)

agg = aggregate(data[,44:46], list(prop=data$prop_female), mean)

pdf("Composition Plot.pdf", width=14, height=7)
span=.3
par(mfrow=c(3,1))
plot(agg$prop, agg$dv_small_group, ylim=c(1,10), xlab="Proportion Female", ylab="Small Group Eval (1-10)", col="blue",pch=16, cex=1)
reg.loess = loess(dv_small_group~prop, data=agg, degree=1, span=span)
pred = predict(reg.loess, agg$prop)
lines(agg$prop, pred, col="red", lwd="2")


plot(agg$prop, agg$dv_efficacy, ylim=c(1,4), xlab="Proportion Female", ylab="Efficacy (1-4)", col="blue",pch=16, cex=1)
reg.loess = loess(dv_efficacy~prop, data=agg, degree=1, span=span)
pred = predict(reg.loess, agg$prop)
lines(agg$prop, pred, col="red", lwd="2")

plot(agg$prop, agg$dv_respect, ylim=c(1,4), xlab="Proportion Female", ylab="Respect (1-4)", col="blue",pch=16, cex=1)
reg.loess = loess(dv_respect~prop, data=agg, degree=1, span=span)
pred = predict(reg.loess, agg$prop)
lines(agg$prop, pred, col="red", lwd="2")

dev.off()


